﻿using System;
using System.Collections.Generic;
using System.Text;
using NUnit.Framework;
using System.IO;
using System.Net;
using Inet.Viewer;
using Inet.Viewer.WinForms;


namespace Inet.Viewer.Data
{
    /// <summary>
    /// 
    /// </summary>
    [TestFixture]
    partial class ReportDataCache
    {

        public ReportDataCache()
        {
        }

        /// <summary>
        /// 
        /// </summary>
        [Test]
        public void TestKeyEquals()
        {
            ReportDataCache.PageCacheKey key = new ReportDataCache.PageCacheKey(ReportDataCache.KeyType.Page, 1);
            ReportDataCache.PageCacheKey key2 = new ReportDataCache.PageCacheKey(ReportDataCache.KeyType.Page, 1);
            Assert.AreEqual(key, key2);
            Assert.AreEqual(key.GetHashCode(), key2.GetHashCode());
        }


        /// <summary>
        /// 
        /// </summary>
        [Test]
        public void TestPagesForRenderData()
        {
            TestRenderData data1 = new TestRenderData("Url1");
            ReportDataCache cache1 = new ReportDataCache(data1);
            cache1.Clear();
            data1.FillPageDataString(1);
            byte[] bytes = cache1.PageData(1, false);
            string bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("1-Url1", bytesString);

            data1.FillPageDataString(2);
            bytes = cache1.PageData(2, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("2-Url1", bytesString);

            TestRenderData data2 = new TestRenderData("Url2");
            ReportDataCache cache2 = new ReportDataCache(data2);
            data2.FillPageDataString(2);
            bytes = cache2.PageData(2, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("2-Url2", bytesString);

            // add "new" to url to test if really the cached version is used
            data2.AddToUrl("new");
            data2.FillPageDataString(2);
            bytes = cache2.PageData(2, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("2-Url2", bytesString, "add to test if really the cached version is used");

            data1.FillPageDataString(5);
            bytes = cache1.PageData(5, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("5-Url1", bytesString);

            data1.FillPageDataString(1);
            bytes = cache1.PageData(1, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("1-Url1", bytesString);

            // add to "new" to url to test if really the cached version is used
            data1.FillPageDataString(2);
            data1.AddToUrl("new");
            bytes = cache1.PageData(2, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual("2-Url1", bytesString, "add to test if really the cached version is used");
        }

        /// <summary>
        /// 
        /// </summary>
        [Test]
        public void TestPageBiggerThanCache()
        {
            TestRenderData data = new TestRenderData("Url1");
            ReportDataCache cache = new ReportDataCache(data);
            cache.Clear();

            // page data > 10 MB
            byte[] bytes;
            data.FillPageDataSize(19999900);
            bytes = cache.PageData(1, false);

            // Should cache this page, even it is bigger than 10 MB
            bytes = cache.PageData(1, false);
            Assert.AreEqual(19999900, bytes.Length, "Should cache this page, even it is bigger than 10 MB");

            // Add a second big page
            data.FillPageDataSize(15555500);
            bytes = cache.PageData(2, false);
            Assert.AreEqual(15555500, bytes.Length, "Second page  bigger than 10 MB should be cached");

            // Add first page again, which should not be in cache any more
            data.FillPageDataSize(16666600);
            bytes = cache.PageData(1, false);
            Assert.AreEqual(16666600, bytes.Length, "This page should be cached");
        }

        /// <summary>
        /// 
        /// </summary>
        [Test]
        public void TestCacheSize()
        {
            string bytesString;
            TestRenderData data = new TestRenderData("Url1");
            ReportDataCache cache = new ReportDataCache(data);
            cache.Clear();

            byte[] bytes;
            // Fill with 10 x 999 990  bytes
            for (int i = 1; i < 11; i++)
            {
                data.FillPageDataSize(999990);
                bytes = cache.PageData(i, false);
            }

            // With this the cache limit will be exceeded
            data.FillPageDataSize(100002);
            byte[] bytes1 = cache.PageData(12, false);
            Assert.AreEqual(100002, bytes1.Length, "With this the cache limit will be exceeded");

            // Get Page data that was deleted by cache
            data.FillPageDataSize(1000);
            bytes = cache.PageData(1, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual(1000, bytes.Length, "Has to receive the new data, as the cache was deleted");
        }

        /// <summary>
        /// Test if the same Page data was requested a second time
        /// </summary>
        [Test]
        public void TestCacheSizeDoubleAdding()
        {
            string bytesString;
            TestRenderData data = new TestRenderData("Url1");
            ReportDataCache cache = new ReportDataCache(data);
            cache.Clear();

            byte[] bytes;
            // Fill with 10 x 999 990  bytes
            for (int i = 1; i < 11; i++)
            {
                data.FillPageDataSize(999900 + i);
                bytes = cache.PageData(i, false);
            }

            // Get the page 1, so it will move to the front of list. Now page 2 should drop with the cache size            
            bytes = cache.PageData(1, false);
            Assert.AreEqual(999901, bytes.Length);

            // With this the cache limit will be exceeded
            data.FillPageDataSize(100002);
            byte[] bytes1 = cache.PageData(12, false);
            Assert.AreEqual(100002, bytes1.Length, "With this the cache limit will be exceeded");

            // Get Page data that was deleted by cache
            data.FillPageDataSize(1000);
            bytes = cache.PageData(2, false);
            bytesString = TestRenderData.GetString(bytes);
            Assert.AreEqual(1000, bytes.Length, "Has to receive the new data, as the cache was deleted");
        }

        /// <summary>
        /// Test if the same Page data was requested a second time
        /// </summary>
        [Test]
        public void TestRefresh()
        {

            TestRenderData data = new TestRenderData("Url1");
            data.pageCount = 5;
            ReportDataCache cache = new ReportDataCache(data);
            cache.Clear();

            byte[] bytes;
            // Fill with 10 x 999 990  bytes
            for (int i = 1; i < 11; i++)
            {
                data.FillPageDataSize(99990 + i);
                // refresh has to be false, as the cache for this data will be emptied if it would be true
                bytes = cache.PageData(i, false);
            }

            // Get the page 1,    
            bytes = cache.PageData(1, false);
            Assert.AreEqual(99991, bytes.Length, " Get the page 1");

            // get cached page 1
            data.FillPageDataSize(111111);
            bytes = cache.PageData(1, false);
            Assert.AreEqual(99991, bytes.Length, "get cached page 1");

            // get enforce refresh page 1
            data.FillPageDataSize(22222);
            bytes = cache.PageData(1, true);
            Assert.AreEqual(22222, bytes.Length, "get enforce refresh page 1");

            // check if the refreshed page is cached correctly
            data.FillPageDataSize(3333);
            bytes = cache.PageData(1, false);
            Assert.AreEqual(22222, bytes.Length, "check if the refreshed page is cached correctly");

            // here the new page 2 should be loaded
            data.FillPageDataSize(444);
            bytes = cache.PageData(2, false);
            Assert.AreEqual(444, bytes.Length, "get  refresh page 2");

            // here the new page 5 should be loaded
            data.FillPageDataSize(555);
            bytes = cache.PageData(5, false);
            Assert.AreEqual(555, bytes.Length, "get  refresh page 5");
        }
    }


    /// <summary>
    /// Test implementation that just sets the url and GetPageData
    /// </summary>
    public class TestRenderData : IRenderData
    {
        byte[] pageData;
        /// <summary>
        /// 
        /// </summary>
        public int pageCount;

        string url;
        /// <summary>
        /// 
        /// </summary>
        /// <param name="str"></param>
        public void AddToUrl(string str)
        {
            url += str;
        }

        #region implement interface IReportData
        /// <summary>
        /// 
        /// </summary>
        /// <param name="url"></param>
        public TestRenderData(string url)
        {
            this.url = url;
        }

        #region NotImplemented
        /// <summary>
        /// 
        /// </summary>
        public void Stop()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        public void ResetServerCacheTimeout()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public object Clone()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        public string ReportTitle
        {
            get
            {
                throw new NotImplementedException();
            }
            set
            {
                throw new NotImplementedException();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        public string ReportLocation
        {
            get
            {
                return url;
            }
            set
            {
                throw new NotImplementedException();
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="page"></param>
        /// <param name="refresh"></param>
        /// <returns></returns>
        public byte[] GetPageData(int page, bool refresh)
        {
            return pageData;
        }

        /// <summary>
        /// 
        /// </summary>
        public int GetPageCount()
        {
            return pageCount; 
        }

        /// <summary>
        /// 
        /// </summary>
        public bool IsPageLimitExceeded
        {
            get { throw new NotImplementedException(); }
        }

        /// <summary>
        /// 
        /// </summary>
        public byte[] GetGrouptreeData()
        {
             throw new NotImplementedException(); 
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="key"></param>
        /// <param name="value"></param>
        public void SetReportParameter(string key, string value)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="key"></param>
        /// <returns></returns>
        public string this[string key]{
            get { throw new NotImplementedException(); }
            set { throw new NotImplementedException(); }
        }

        /// <summary>
        /// 
        /// </summary>
        public bool PromptOnRefresh
        {
            get
            {
                throw new NotImplementedException();
            }
            set
            {
                throw new NotImplementedException();
            }
        }
        #endregion

        /// <summary>
        /// To generate pageData with the following size
        /// </summary>
        /// <param name="size"></param>
        public void FillPageDataSize(int size)
        {
            pageData = new byte[size];
        }

        /// <summary>
        /// Set pageData with page and url as string in bytes encoded
        /// </summary>
        /// <param name="page"></param>
        public void FillPageDataString(int page)
        {
            pageData = TestRenderData.GetBytes(page + "-" + this.url);
        }
      
        #endregion

        /// <summary>
        /// 
        /// </summary>
        /// <param name="str"></param>
        /// <returns></returns>
        public static byte[] GetBytes(string str)
        {
            byte[] bytes = new byte[str.Length * sizeof(char)];
            System.Buffer.BlockCopy(str.ToCharArray(), 0, bytes, 0, bytes.Length);
            return bytes;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="bytes"></param>
        /// <returns></returns>
        public static string GetString(byte[] bytes)
        {
            char[] chars = new char[bytes.Length / sizeof(char)];
            System.Buffer.BlockCopy(bytes, 0, chars, 0, bytes.Length);
            return new string(chars);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="fontID"></param>
        /// <returns></returns>
        public byte[] GetFontData(int fontID)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="expProps"></param>
        /// <returns></returns>
        public int GetExportChunkCount(Dictionary<string, string> expProps)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="phrase"></param>
        /// <param name="startPage"></param>
        /// <param name="flags"></param>
        /// <returns></returns>
        public byte[] Search(string phrase, int startPage, SearchOption flags)
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public byte[] NextExportChunk()
        {
            throw new NotImplementedException();
        }

        public ReportState Ping()
        {
            throw new NotImplementedException();
        }
    }
}


